
/*
----------------------------------------------------------------------
Top16 - II
Operating system
Version 1.1

(c) TCTEC Pty Ltd  www.tctec.net


12-April-2015        RVW      Version 1.0         Created
13-August-2015       RVW      Version 1.1         Code tidy up



----------------------------------------------------------------------
*/

/* ============================================================================
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
===============================================================================
*/
#include <Wire.h>
#include "ADS1115.h"


#define LED (13)

ADS1115 adc0(ADS1115_DEFAULT_ADDRESS); 

struct GLOBALS {

   int gainSetting ;
   
}globals;


int outputPinMap[8] = {2,3,4,5,6,7,8,9};

const int SERIALBUFSIZE = 16 ;
char  rxBuffer[SERIALBUFSIZE] ;
int rxBufCount = 0 ;
int analogReadings[8] ;

void setupDigitalOutputs()
{
  int count = 0 ;
  
  for(count = 0 ; count < 8; count++)
  {
    pinMode(outputPinMap[count], OUTPUT) ;
  }
}

void processSerial()
{
  int in ;
  in = Serial.read() ;
  
  if (in > -1)
  {        
    // command ?
    //
    if ((in == '\r') || (in == '\n'))
    {
      processCommand(rxBuffer) ;
      
      rxBuffer[rxBufCount] = 0 ;
           
      // reset the buffer
      //
      rxBufCount = 0 ;
      
    }    
    else
    {
      rxBuffer[rxBufCount] = in ;     
      rxBufCount++ ;
    
      if (rxBufCount > SERIALBUFSIZE)
      {
        rxBufCount = 0 ;
      }
    }
  }  
}

void setup() {     

    setupDigitalOutputs() ;  
  
    pinMode(A0, OUTPUT) ;
    pinMode(A1, OUTPUT) ;
    pinMode(A2, OUTPUT) ;
    
    // LED
    //
    pinMode(LED, OUTPUT) ;
    digitalWrite(LED, HIGH) ;
    
    digitalWrite(A0, LOW) ;
    digitalWrite(A1, LOW) ;
    digitalWrite(A2, LOW) ;
          
    Wire.begin();  // join I2C bus
    Serial.begin(115200); // initialize serial communication 
   
    // Serial.println("Initializing I2C devices..."); 
    adc0.initialize(); // initialize ADS1115 16 bit A/D chip
    
    //Serial.println("Testing device connections...");
    //Serial.println(adc0.testConnection() ? "ADS1115 connection successful" : "ADS1115 connection failed");
      
    // To get output from this method, you'll need to turn on the 
    //#define ADS1115_SERIAL_DEBUG // in the ADS1115.h file
    adc0.showConfigRegister();
    
    // Set the gain (PGA)
    //
    adc0.setGain(ADS1115_PGA_6P144 );
    
    adc0.setRate(ADS1115_RATE_475);
    
    //  continuous sampling
    //
    adc0.setMode(ADS1115_MODE_CONTINUOUS);       

}

double volts ;

void callback()
{
  
}

void loop() 
  {
    static byte outputState = 0x01 ;
    static byte outputCount = 0 ;
    static long loopCount = 0 ;
    
    loopCount++ ;
    
    if (loopCount > 20000)  // ~ 100 mSec
    {
      loopCount = 0 ; 
      digitalWrite(LED, HIGH) ;
     
    }
    
    //  setDigitalOutputs(outputState, 0xFF) ;
         
    outputState <<= 1;
    
    outputCount++ ;
    
    if (outputCount >= 8)
    {
      outputCount = 0 ; 
      outputState = 0x01 ;    
    }
    
    //  readNextAnalogInput() ;
    
    processSerial();
    
    // delay(5);
  }
  
void setDigitalOutputs(byte state, byte mask)
{
  
  int count = 0 ;
  int checkMask = 0x01 ;
  
  // if the mask bit is set, then change the state of the output
  //
  
  for(count = 0 ; count < 8; count++)
  {
    if (checkMask & mask)
    {
      if (checkMask & state)
      {
        digitalWrite(outputPinMap[count], HIGH);
      }
      else
      {
        digitalWrite(outputPinMap[count], LOW) ;
      }
    }
    checkMask <<= 1 ;    
  }   
}

/* set the analog Gain (range)

The options are:

#define ADS1115_PGA_6P144           0x00
#define ADS1115_PGA_4P096           0x01
#define ADS1115_PGA_2P048           0x02 
#define ADS1115_PGA_1P024           0x03
#define ADS1115_PGA_0P512           0x04
#define ADS1115_PGA_0P256           0x05
#define ADS1115_PGA_0P256B          0x06
#define ADS1115_PGA_0P256C          0x07

*/
void setGain(uint8_t gain)
{    
    adc0.setGain(gain);  
    globals.gainSetting = gain ;    
}

/*
Continuously read the inputs and update the reading array 
*/
void readNextAnalogInput()
{
  static byte input = 0 ;  
  
  // get sample
  //
  analogReadings[input] = adc0.getConversionP0GND();
  
  input++ ;  
  if (input > 7)
  {
    input = 0 ;
  }
  // set MUX address for next input
  //  
  PORTC &= 0b11111000;
  PORTC |= input ;
  
  /*digitalWrite(A0, (input & 0x01)) ;
  digitalWrite(A1, (input & 0x02)) ;
  digitalWrite(A2, (input & 0x04)) ;
  */
  
}

double readAnalogIn(int input)
{ 
  int actualInput = 0 ;
  
  if (input > 8)
  {
    input = 1 ;
  }
  input-- ;
  
  switch (input)
  {
    case 7: actualInput = 0 ; break ;
    case 6: actualInput = 1 ; break ;
    case 5: actualInput = 2 ; break ;
    case 4: actualInput = 3 ; break ;
    case 3: actualInput = 4 ; break ;
    case 2: actualInput = 5 ; break ;
    case 1: actualInput = 6 ; break ;
    case 0: actualInput = 7 ; break ;
    
  }
  
  // set MUX address 
  //  
  PORTC &= 0b11111000;
  PORTC |= actualInput ; 
  
  delay(5) ; 
  
  // get sample
  //
  return(adc0.getConversionP0GND()* adc0.getMvPerCount());    
  
}

int readDigitalInput(int input)
{  
  
  int digitalState = 0 ;  
  int gain = globals.gainSetting ; // remember the gain setting
  
  // temporarily set the analog gain to 6.144 Volts
  //
  
  setGain(0) ;
  
  // read analog voltages and convert to digital
  //
  if(readAnalogIn(input) > 2500)   // 2.5 volts
  {
    digitalState = 1 ;
  }
  else
  {
    digitalState = 0 ;
  }
  setGain(globals.gainSetting) ;  
  return(digitalState) ;  
  
}


/*

Valid PWM output pins are:
2,4,5,8

*/
void setPWM(int pin, int Value)
{
  // make sure Value is valid
  //
  Value &= 0xFF ;
  
  if (pin == 2)
  {
    analogWrite(3, Value) ;
  }
  else if (pin == 4)
  {
    analogWrite(5, Value) ;    
  }
  else if (pin == 5)
  {
    analogWrite(6, Value) ;
  }
  else if (pin == 8)
  {
    analogWrite(9, Value) ;
  }
  
}


