#include <stdio.h>

/*
--------------------------------------------------------------------
Top16 II  commands.ino
Version 1.1

Command set, command processing.

18-April-2015  RVW   Version 1.0  Created


--------------------------------------------------------------------
*/

#define VERSIONSTRING "1.0"
char  txString[SERIALBUFSIZE] ;


int hexcharToNibble(char hex)
{
  int output ;
  
  output = 0 ;  
   
  if ((hex >= '0') && (hex <= '9'))
  {
    output |= (hex - '0') ;
  }
  else if ((hex >= 'A') && (hex <= 'F'))
  {
    output = 0x0A + (hex - 'A') ;
  }
  else
  {
    output = -1 ;
  }  
      
  return(output) ;
}


/*
--------------------------------------------------------------------

Commands:

?<CR>      Return firmware version
#zi<CR>    Read analog input 'i'
#yg<CR>    Set analog gain to 'g'
#xi<CR>    Read digital input 'i'
#poVV<CR>  Set PWM on output 'o' to value VV (00 to FF)



--------------------------------------------------------------------
*/

void processCommand(char *command)
{  
  int tempI = 0; 
  int output = 0;
  int mask = 0 ;
  double tempf ;
  if (command[0] == '?')
  {
    Serial.println(VERSIONSTRING) ;
    return ;
  }
  if (command[0] != '#')
  {
    // send a prompt
    //
    Serial.print("\r>") ; 
    return ;
  }
  
  // turn the LED off
  //
  digitalWrite(13, LOW) ;
  
  tempI = hexcharToNibble(command[1]) ; // digit 1
  
  output |= (tempI << 4) ;        
  tempI = hexcharToNibble(command[2]) ; // digit 2
      
  output |= tempI ;      
      
  tempI = hexcharToNibble(command[3]) ; // digit 3
  mask |= (tempI << 4) ;
      
  tempI = hexcharToNibble(command[4]) ; // digit 4
  mask |= (tempI) ;      
        
  if ((mask <= 0xFF) && (mask >= 0) && (output <= 0xFF) && (output >= 0))
  {
    // set the digital outputs
    //      
    setDigitalOutputs(output, mask) ;  
    Serial.println(">OK") ;   
  }

  if(command[1] == 'z')
  {
    tempI = hexcharToNibble(command[2]) ;
    tempf = readAnalogIn(tempI) ;
    dtostrf(tempf,7,2,txString);  
    Serial.print(">") ;
    Serial.println(txString) ;
  }  
  else if (command[1] == 'y')
  {    
    tempI = hexcharToNibble(command[2]) ;
    setGain(tempI);    
  }
  else if (command[1] == 'x')
  {
    tempI = readDigitalInput(command[2]);
    
    Serial.print(">") ;
    Serial.println(tempI) ;
  }
  
  else if (command[1] == 'p')
  {
    // PWM command
    //
    output = 0 ;
    tempI = hexcharToNibble(command[3]) ;
    output |= (tempI << 4) ;
    
    tempI = hexcharToNibble(command[4]) ;
    output |= tempI ;
    
    mask = hexcharToNibble(command[2]) ;
    
    setPWM(mask,output) ;
    
    Serial.println(">OK") ;        
    
  }
  
    
}
